<?php
namespace Opencart\Catalog\Controller\Extension\OrderTotals\Total;
class Coupon extends \Opencart\System\Engine\Controller {  
	public function index() {
		if ($this->config->get('total_coupon_status')) {
			$this->load->language('extension/order_totals/total/coupon');

			if (isset($this->session->data['coupon'])) {
				$data['coupon'] = $this->session->data['coupon'];
			} else {
				$data['coupon'] = '';
			}

			return $this->load->view('extension/order_totals/total/coupon', $data);
		}
	}

	public function coupon() {
		$this->load->language('extension/order_totals/total/coupon');

		$json = array();

		$this->load->model('extension/order_totals/total/coupon');

		if (isset($this->request->post['coupon'])) {
			$coupon = $this->request->post['coupon'];
		} else {
			$coupon = '';
		}

		$coupon_info = $this->model_extension_order_totals_total_coupon->getCoupon($coupon);

		if (empty($this->request->post['coupon'])) {
			$json['error'] = $this->language->get('error_empty');

			unset($this->session->data['coupon']);
		} elseif ($coupon_info) {
			$this->session->data['coupon'] = $this->request->post['coupon'];

			$this->session->data['success'] = $this->language->get('text_success');

			$json['redirect'] = $this->url->link('checkout/cart');
		} else {
			$json['error'] = $this->language->get('error_coupon');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
